﻿//////////////////////////////////////////////
// ResourceDeclAugmentCallback.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkExport
{
	class Node ;
}

namespace nkGraphics
{
	class Camera ;
	class Mesh ;
	class RenderQueue ;
	class Shader ;
	class Texture ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ResourceDeclAugmentCallback
	{
		public :

			// Constructor, destructor
			ResourceDeclAugmentCallback () noexcept ;
			virtual ~ResourceDeclAugmentCallback () ;

			// Callbacks
			virtual void onCamera (Camera* camera, nkExport::Node* rootNode) ;
			virtual void onMesh (Mesh* mesh, nkExport::Node* rootNode) ;
			virtual void onRenderQueue (RenderQueue* renderQueue, nkExport::Node* rootNode) ;
			virtual void onShader (Shader* shader, nkExport::Node* rootNode) ;
			virtual void onTexture (Texture* texture, nkExport::Node* rootNode) ;
	} ;
}